<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saved_analyses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('project_id')->nullable()->constrained()->onDelete('set null');
            $table->string('name'); // User-friendly name
            $table->string('type'); // serp, keywords, backlinks, onpage, domain, content
            $table->string('target')->nullable(); // Domain/keyword being analyzed
            $table->json('parameters'); // Input parameters used
            $table->json('results')->nullable(); // Cached results
            $table->json('summary')->nullable(); // Quick stats for listing
            $table->string('status')->default('completed'); // pending, completed, failed
            $table->decimal('cost', 10, 6)->default(0); // API cost for this analysis
            $table->timestamp('expires_at')->nullable(); // When cached results expire
            $table->boolean('is_favorite')->default(false);
            $table->timestamps();
            
            $table->index(['user_id', 'type']);
            $table->index(['user_id', 'project_id']);
            $table->index(['user_id', 'is_favorite']);
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saved_analyses');
    }
};
