<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2);
            $table->string('billing_period')->default('monthly'); // monthly, yearly
            $table->string('stripe_price_id')->nullable();
            $table->integer('credits_per_month')->default(0);
            $table->integer('api_calls_per_day')->default(100);
            $table->integer('projects_limit')->default(5);
            $table->integer('team_members_limit')->default(1);
            $table->json('features')->nullable(); // List of features
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('sort_order')->default(0);
            $table->string('badge')->nullable(); // "Most Popular", "Best Value"
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
